Attribute VB_Name = "Module1"
Option Explicit
'dzzie@yahoo.com
'http://sandsprite.com

Public Type ImgDataDir
    pFuncAry As Long
    timestamp As Long
    forwarder As Long
    pDllName As Long
    pThunk As Long
End Type

Public Type ImgDosHeader
    stuff(1 To 60) As Byte 'soak up uneeded fields
    pOptHeader As Long
End Type

Public Type ImgOptHeader
    Signature As String * 4      '\
    Machine As Integer           ' \_ 128
    NumberofSections As Integer  ' /
    'stuff(1 To 120) As Byte      '/
    stuff(1 To 72) As Byte
    SizeOfImage As Long
    stuff2(1 To 44) As Byte
    pImportTable As Long    'datadir(Import_Table).rvaAddress
    ImportSize As Long      'datadir(Import_Table).size
    ddRemainder(1 To 112) As Byte
End Type

Public Type SECTION_HEADER
    nameSec As String * 6
    PhisicalAddress As Integer
    VirtualSize As Long
    VirtualAddress As Long
    SizeOfRawData As Long
    PointerToRawData As Long
    stuff(1 To 12) As Byte
    Characteristics As Long
End Type

Global Sections As New Collection
Global CanAddSection As Boolean

Function FileExists(path) As Boolean
  If Len(path) = 0 Then Exit Function
  If Dir(path, vbHidden Or vbNormal Or vbReadOnly Or vbSystem) <> "" Then FileExists = True
End Function

Sub push(ary, value) 'this modifies parent ary object
    On Error GoTo init
    Dim x
    x = UBound(ary) '<-throws Error If Not initalized
    ReDim Preserve ary(UBound(ary) + 1)
    ary(UBound(ary)) = value
    Exit Sub
init:     ReDim ary(0): ary(0) = value
End Sub

'modified for objects
Function cKeyExistsInCollection(c As Collection, val As String) As Boolean
    On Error GoTo nope
    Dim t
    Set t = c(val)
    cKeyExistsInCollection = True
 Exit Function
nope: cKeyExistsInCollection = False
End Function

Function KeyExistsInCollection(c As Collection, val As String) As Boolean
    On Error GoTo nope
    Dim t
    t = c(val)
    KeyExistsInCollection = True
 Exit Function
nope: KeyExistsInCollection = False
End Function

Function StrToAsc(str As String, Optional bufSize As Long = -1) As Byte()
    Dim b() As Byte
    b() = StrConv(str, vbFromUnicode)
    If bufSize > 0 Then ReDim Preserve b(bufSize)
    StrToAsc = b()
End Function

Sub BlankLine(fHand As Long)
    Dim b(1 To 16) As Byte
    Put fHand, , b()
End Sub

Function SumElem(lngAry() As Long, lb As Long, ub As Long) As Long
    On Error Resume Next
    Dim ret As Long, i As Long
    For i = lb To ub
        ret = ret + lngAry(i)
    Next
    SumElem = ret
End Function

Sub Align(ByRef v As Long)
    While v Mod 16 <> 0
        v = v + 1
    Wend
End Sub

Sub ImportTableAddress(fpath As String, pImportTable As Long, szTable As Long, Optional SetValues As Boolean = False)
    
    If Not FileExists(fpath) Then
        MsgBox "File not found: " & fpath
        Exit Sub
    End If
    
    Dim f As Long, i As Long
    Dim dos As ImgDosHeader
    Dim opt As ImgOptHeader
    Dim udtSH As SECTION_HEADER
    Dim csect As CSection
    
    f = FreeFile
        
    Dim tmpImgBase As Long
        
    Open fpath For Binary As f
    Get f, , dos
    Get f, dos.pOptHeader + 1 + 52, tmpImgBase
    Get f, dos.pOptHeader + 1, opt
    
    frmMain.ImageBase = tmpImgBase
    
    If SetValues Then
        opt.ImportSize = szTable
        opt.pImportTable = pImportTable
        Put f, dos.pOptHeader + 1, opt
    Else
        pImportTable = opt.pImportTable
        szTable = opt.ImportSize
    End If
    
    Close f
        
End Sub
 
Sub LoadSections(fpath As String)
    
    If Not FileExists(fpath) Then
        MsgBox "File not found: " & fpath
        Exit Sub
    End If
    
    Dim f As Long, i As Long
    Dim dos As ImgDosHeader
    Dim opt As ImgOptHeader
    Dim udtSH As SECTION_HEADER
    Dim csect As CSection
    Dim rawSize As Long
    
    f = FreeFile
    
    Open fpath For Binary As f
    Get f, , dos
    Get f, dos.pOptHeader + 1, opt
     
    Set Sections = New Collection
    
    For i = 1 To opt.NumberofSections
        Get f, , udtSH
        Set csect = New CSection
        csect.LoadStruc udtSH
        Sections.Add csect
        rawSize = rawSize + csect.SizeOfRawData
    Next
    
    Dim blankSH() As Byte
    ReDim blankSH(Len(udtSH) * 2) 'one more for data, one more to terminate
    
    Get f, , blankSH()
    
    CanAddSection = True
    
    For i = 0 To UBound(blankSH)
        If blankSH(i) <> 0 Then
            CanAddSection = False
            Exit For
        End If
    Next
    
    Close f
    
    
    
End Sub


Function SaveSections(fpath As String) As Boolean

    On Error GoTo hell
    
    If Not FileExists(fpath) Then
        MsgBox "File not found: " & fpath
        Exit Function
    End If
    
    If Sections.Count = 0 Then
        MsgBox "You have not yet created any sections?"
        Exit Function
    End If
    
    Dim f As Long, i As Long
    Dim dos As ImgDosHeader
    Dim opt As ImgOptHeader
    Dim udtSH As SECTION_HEADER
    Dim csect As CSection
    Dim rawSize As Long
    Dim buf() As Byte
    
    f = FreeFile
    
    Open fpath For Binary As f
    Get f, , dos
    Get f, dos.pOptHeader + 1, opt
     
    Set csect = Sections(Sections.Count)
    rawSize = csect.VirtualAddress + csect.VirtualSize

    opt.SizeOfImage = rawSize
    opt.NumberofSections = Sections.Count
    Put f, dos.pOptHeader + 1, opt
    
    For Each csect In Sections
        csect.GetStruc udtSH
        Put f, , udtSH
    Next
    
    For Each csect In Sections
        If csect.NeedsAllocation And csect.SizeOfRawData > 0 Then
            csect.NeedsAllocation = False
            ReDim buf(csect.SizeOfRawData)
            Put f, LOF(f), buf
        End If
    Next
    
    Close f
    SaveSections = True
    
    Exit Function
hell: MsgBox Err.Description
End Function

Function RvaToOffset(ByVal rva As Long, Optional ByRef VirtualSectionBase As Long, Optional sectName As String)
        
    If Sections.Count = 0 Then
        MsgBox "No Sections Loaded", vbInformation
        Exit Function
    End If
    
    Dim c As CSection
    Dim vBase As Long, vSize As Long, vMax As Long
    
    For Each c In Sections
       vBase = c.VirtualAddress
       vSize = c.VirtualSize
       vMax = vBase + vSize
       
       If rva >= vBase And rva < vMax Then 'right section
            rva = rva - vBase
            rva = rva + c.PointerToRawData
            RvaToOffset = rva
            VirtualSectionBase = vBase
            sectName = c.nameSec
            Exit Function
       End If
    Next
       
    
End Function

Function OffsetToRVA(ByVal fOffset As Long, Optional sectName As String)
    
    If Sections.Count = 0 Then
        MsgBox "No Sections Loaded", vbInformation
        Exit Function
    End If
    
    Dim c As CSection
    Dim rBase As Long, rSize As Long, rMax As Long
    
    For Each c In Sections
       rBase = c.PointerToRawData
       rSize = c.SizeOfRawData
       rMax = rBase + rSize
       
       If fOffset >= rBase And fOffset < rMax Then 'right section
            OffsetToRVA = c.VirtualAddress + fOffset - rBase
            sectName = c.nameSec
            Exit Function
       End If
    Next

End Function

Function GetHextxt(t As TextBox, v As Long) As Boolean
    
    On Error Resume Next
    v = CLng("&h" & t)
    If Err.Number > 0 Then
        MsgBox "Error " & t.Text & " is not valid hex number", vbInformation
        Exit Function
    End If
    
    GetHextxt = True
    
End Function

Sub Enable(t As TextBox, Optional enabled = True)
    t.BackColor = IIf(enabled, vbWhite, &H80000004)
    t.enabled = enabled
    t.Text = Empty
End Sub
